/*:
 * @target MZ
 * @plugindesc Adds a larger outline around the font with custom color and text padding.
 * @help This plugin adds a larger outline around the font with custom color and text padding.
 */
(() => {
    const outlineColor = 'rgba(58, 58, 80, 1)'; // Outline color (custom color: #3a3a50)
    const outlineWidth = 6; // Outline width in pixels
    const textPaddingTop = 10; // Padding above the text

    const _Window_Base_resetFontSettings = Window_Base.prototype.resetFontSettings;
    Window_Base.prototype.resetFontSettings = function() {
        _Window_Base_resetFontSettings.call(this);
        this.contents.outlineWidth = outlineWidth; // Set custom outline width
        this.contents.outlineColor = outlineColor; // Set custom outline color
    };

    const _Window_Message_newPage = Window_Message.prototype.newPage;
    Window_Message.prototype.newPage = function(textState) {
        _Window_Message_newPage.call(this, textState);
        this.resetFontSettings(); // Apply the outline settings on new page
    };

    const _Window_Message_drawTextEx = Window_Message.prototype.drawTextEx;
    Window_Message.prototype.drawTextEx = function(text, x, y) {
        return _Window_Message_drawTextEx.call(this, text, x, y + textPaddingTop);
    };
})();

